<?php

namespace App\Restaurants;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Restaurant extends Model 
{

    protected $table = 'restaurants';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function activations()
    {
        return $this->hasMany('RestaurantActivation');
    }

    public function payments()
    {
        return $this->hasMany('RestaurantPayment');
    }

    public function translations()
    {
        return $this->hasMany('RestaurantTranslation');
    }

}